@../params.sql
-- umoznime pouzitie inicializacnych parametrov
set define on
set echo on

prompt Prihlasime sa ako pouzivatel teller
connect teller/&teller_pass&db_name


set echo off
prompt Nastavime namespace na bank_is, aby sme nemuseli pouzivat prefixy
pause Pre pokracovanie stlacte Enter
set echo on
alter session set current_schema=bank_is;

set echo off
pause Pre pokracovanie stlacte Enter
prompt Autentifikujeme sa do systemu
set echo on
begin
 employee_context_pkg.init_context('jcash', -- meno  
                                   sys.dbms_crypto.hash(sys.utl_i18n.string_to_raw('jcashheslo', 'AL32UTF8') || 
                                                        employee_context_pkg.get_salt('jcash'), 
                                                        sys.dbms_crypto.HASH_SH1)); -- SHA-1(heslo || sol) 
end;
/

variable new_client_id number

set echo off
pause Pre pokracovanie stlacte Enter
prompt Vygenerujeme id pre noveho zakaznika
pause Pre pokracovanie stlacte Enter
set echo on
begin 
SELECT seq_client_id.NEXTVAL 
INTO :new_client_id
FROM dual;
end;
/

set echo off
pause Pre pokracovanie stlacte Enter
prompt Pokusime o vytvorenie obycajneho zakaznika, pokus bude uspesny
pause Pre pokracovanie stlacte Enter
set echo on
INSERT INTO v_teller_i_client (id, first_name, last_name, login, password, salt, phone_no, address, client_type)
VALUES (:new_client_id, 'Jozef', 'Mrkvicka', 'jmrkvicka', hextoraw('AA'), hextoraw('BB'), '0908156789', 'Mokrohajska', 'COMMON');

set echo off
pause Pre pokracovanie stlacte Enter
prompt Nastavime id noveho zakaznika do aplikacneho kontextu
pause Pre pokracovanie stlacte Enter
set echo on

execute employee_context_pkg.set_client_id(:new_client_id)

set echo off
pause Pre pokracovanie stlacte Enter
prompt Pozrieme sa na udaje prave vytvoreneho zakaznika
pause Pre pokracovanie stlacte Enter
set echo on
select * from v_all_client;


set echo off
pause Pre pokracovanie stlacte Enter
prompt Vygenerujeme id pre novy ucet
pause Pre pokracovanie stlacte Enter
set echo on

variable new_account_no number

begin 
SELECT seq_account_no.nextval
INTO :new_account_no
FROM dual;
end;
/


set echo off
pause Pre pokracovanie stlacte Enter
prompt Vytvorime ucty pre prave vytvoreneho zakaznika
pause Pre pokracovanie stlacte Enter
set echo on
insert into v_all_account(id, account_no, account_type, client_id, day_limit, valid)
values (seq_account_id.nextval, :new_account_no, 1, sys_context('bank_context', 'client_id'), 5000, 1);
insert into v_all_account(id, account_no, account_type, client_id, day_limit, valid)
values (seq_account_id.nextval, seq_account_no.nextval, 1, sys_context('bank_context', 'client_id'), 2000, 1);

set echo off
pause Pre pokracovanie stlacte Enter
prompt Pozrieme na sa informacie o tychto uctoch
pause Pre pokracovanie stlacte Enter
set echo on
select * from v_all_account;

set echo off
pause Pre pokracovanie stlacte Enter
prompt nastavime prave vytvoreny ucet do kontextu
pause Pre pokracovanie stlacte Enter
set echo on

execute employee_context_pkg.set_account_no(:new_account_no);

set echo off
pause Pre pokracovanie stlacte Enter
prompt Vytvorime pre tento ucet kartu
pause Pre pokracovanie stlacte Enter
set echo on

insert into v_all_card(id,account_no,card_no,valid_thru,atm_limit,pay_limit,valid)
values(seq_card_id.nextval, sys_context('bank_context', 'account_no'), '1111111112', sysdate+365, 1000, 2000, 1);


set echo off
pause Pre pokracovanie stlacte Enter
prompt Zobrazime informacie o karte z pohladu v_all_card
pause Pre pokracovanie stlacte Enter
set echo on

select * from v_all_card;

set echo off
pause Pre pokracovanie stlacte Enter
prompt Vyskusame vytvorit noveho biznis zakaznika, co skonci chybou 
prompt pretoze jcash je pracovnik pre obycajnych zakaznikov
pause Pre pokracovanie stlacte Enter
set echo on

INSERT INTO v_teller_i_client
  (id, first_name, last_name, login, password, salt, phone_no, address, client_type)
VALUES (seq_client_id.nextval,  'Linus', 'Torvalds', 'ltorvalds', hextoraw('AA'), hextoraw('BB'), '0903666541', 'Somewhere in USA', 'B2B');

set echo off
pause Pre pokracovanie stlacte Enter
prompt Autentifikujeme sa do systemu, teda ako pracovnik pre biznis zakaznikov
set echo on
begin
 employee_context_pkg.init_context('tkyte', -- meno  
                                   sys.dbms_crypto.hash(sys.utl_i18n.string_to_raw('tkyteheslo', 'AL32UTF8') || 
                                                        employee_context_pkg.get_salt('tkyte'), 
                                                        sys.dbms_crypto.HASH_SH1)); -- SHA-1(heslo || sol) 
end;
/

set echo off
pause Pre pokracovanie stlacte Enter
prompt Vygenerujeme id pre noveho biznis zakaznika
pause Pre pokracovanie stlacte Enter
set echo on
begin 
SELECT seq_client_id.NEXTVAL 
INTO :new_client_id
FROM dual;
end;
/

set echo off
pause Pre pokracovanie stlacte Enter
prompt Pokusime sa vytvorit biznis zakaznika. Tento raz pokus bude uspesny.
pause Pre pokracovanie stlacte Enter
set echo on

INSERT INTO v_teller_i_client
  (id, first_name, last_name, login, password, salt, phone_no, address, client_type)
VALUES (:new_client_id,  'Linus', 'Torvalds', 'ltorvalds', hextoraw('AA'), hextoraw('BB'), '0903666541', 'Somewhere in USA', 'B2B');

set echo off
pause Pre pokracovanie stlacte Enter
prompt Nastavime teda id zakaznika do kontextu a pozrieme sa na jeho informacie
pause Pre pokracovanie stlacte Enter
set echo on

execute employee_context_pkg.set_client_id(:new_client_id)
select * from v_all_client;


set echo off
pause Pre pokracovanie stlacte Enter
prompt Overime, ze pracovnik pre biznis zakaznikov nemoze vytvorit obycajneho zakaznika
pause Pre pokracovanie stlacte Enter
set echo on

INSERT INTO v_teller_i_client (id, first_name, last_name, login, password, salt, phone_no, address, client_type)
VALUES (seq_client_id.NEXTVAL, 'Robert', 'Bezny', 'rbezny', hextoraw('AA'),  hextoraw('BB'),'0904444222', 'Stare Grunty', 'COMMON');


set echo off
pause Pre pokracovanie stlacte Enter
prompt Zmeny neulozime do databazy
pause Pre pokracovanie stlacte Enter
set echo on
rollback;

pause Pre pokracovanie stlacte Enter
prompt Ukoncime spojenie
exit

